<?php
/**************************************************
* This file contains only theme specific functions.
* Do not edit this file unless you know what you are
* doing.
***************************************************/
/*************************************************
* Include mobile detect
**************************************************/
function carzine_get_current_daytime(){
    $date_format = get_option('date_format');
    $get_daytime = date($date_format);
    return $get_daytime;
}
function carzine_return_trimmed_content($content,$wordcount){
    $more_link = get_permalink();
    $trimmed_content = wp_trim_words($content,$wordcount,'...<a class = "read-more-link" href="'.$more_link.'">'.__('+More','carzine').'</a>');
    return $trimmed_content;
}
function carzine_is_video_format($pid){
    $post_format = get_post_format($pid);
    if($post_format == "video"):
        return true;
    else:
        return false;
    endif;
        
    
}                                           
/***********************************************************
* Our Options
************************************************************/
get_template_part('theme_includes/settings-class');
if (!class_exists('carzine_Settings' )):
class carzine_Settings {

    private $settings_api;

    function __construct() {
        $this->settings_api = new carzine_Settings_API;
        add_action( 'admin_init', array($this, 'admin_init') );
        add_action( 'admin_menu', array($this, 'admin_menu') );
    }

    function admin_init() {

        //set the settings
        $this->settings_api->set_sections( $this->get_settings_sections() );
        $this->settings_api->set_fields( $this->get_settings_fields() );

        //initialize settings
        $this->settings_api->admin_init();
    }
    
    /***
    * Enqueue scripts to admin page only
    * 
    */
    function admin_menu() {
       function carzine_admin_scripts(){
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_style( 'thickbox' );
        wp_enqueue_script( 'wp-color-picker' );
        wp_enqueue_script( 'jquery' );
        wp_enqueue_script( 'media-upload' );
        wp_enqueue_script( 'thickbox' );
        wp_enqueue_style('admins',CSS_PATH.'admin_area.css','','','all');
        wp_enqueue_media();
    }
    $carzine_opts = add_theme_page('carzine Settings', 'carzine Settings', 'delete_posts', OPTIONS_PREFIX.'theme_settings', array($this, 'plugin_page'));
    add_action('admin_print_scripts-' .$carzine_opts, 'carzine_admin_scripts' );
    }
   
function get_settings_sections() {
        $sections = array(
            array(
                'id' => OPTIONS_PREFIX.'general',
                'title' => __( 'carzine General', 'carzine' ),
                'desc'=>__('General  Settings','carzine')
            ),
            array(
                'id' => OPTIONS_PREFIX.'socials',
                'title' => __( 'carzine Social', 'carzine' ),
                'desc'=>__('Facebook,Twitter, G+ etc settings.','carzine')
            ),
            array(
                'id' => OPTIONS_PREFIX.'featured_post_settings',
                'title' => __( 'Featured Posts Settings', 'carzine' ),
                'desc'=>__('Featured Post Category, featured posts excerpts length.','carzine')
            ),
            array(
                'id' => OPTIONS_PREFIX.'footer_columns',
                'title' => __( 'carzine Footer', 'carzine' ),
                'desc'=>__('Fill the footer columns with your text.','carzine')
            ),
        );
        return $sections;
    }
    
    function get_settings_fields() {
        //Access the WordPress Categories via an Array
        $categories = array();  
        $categories_obj = get_categories('hide_empty=0');
            foreach ($categories_obj as $cat) {
            $categories[$cat->cat_ID] = ucwords($cat->cat_name);  
            }
            global $allowedtags;
        $settings_fields = array(
            OPTIONS_PREFIX.'general' => array(
            array(
                    'name' => 'favicon',
                    'label' => __( 'Your Favicon', 'carzine' ),
                    'desc' => __( '<p>If you have a favicon (16x16px) please upload it here.</p>','carzine' ),
                    'type' => 'file',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
                ),
             array(
                    'name' => 'logo',
                    'label' => __( 'Your Logo', 'carzine' ),
                    'desc' => __( '<p>Do you a have a logo to upload?If yes, use the media uploader.Suggested logo dimensions are 375x125px.</p>', 'carzine' ),
                    'type' => 'file',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            ),
            array(
                    'name' => 'top_area_text',
                    'label' => __( 'Top Area Slogan', 'carzine' ),
                    'desc' => __( '<p>This is the message that appears between the date and the social icons, at the top.</p><p>Keep it small and simple, up to three-seven words.Leave it blank and the message will disappear</p>', 'carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'sanitize_text_field'
            ),
            array(
                    'name' => 'top_bar_bg',
                    'label' => __( 'Top Bar Bg Color', 'carzine' ),
                    'desc' => __( 'Choose top bar(social bar color)', 'carzine' ),
                    'type' => 'color',
                    'default' => '',
                    'sanitize_callback'=>'sanitize_hex_color'
            ),
            array(
                    'name' => 'top_bar_font_color',
                    'label' => __( 'Top Bar General Font', 'carzine' ),
                    'desc' => __( 'Choose top bar general font color', 'carzine' ),
                    'type' => 'color',
                    'default' => '',
                    'sanitize_callback'=>'sanitize_hex_color'
            ),
            array(
                    'name' => 'top_bar_icon_color',
                    'label' => __( 'Top bar icon color', 'carzine' ),
                    'desc' => __( 'Choose top bar icon color.Be careful, this will override the hover color.', 'carzine' ),
                    'type' => 'color',
                    'default' => '',
                    'sanitize_callback'=>'sanitize_hex_color'
            ),
            array(
                    'name' => 'top_bar_icon_bg_hover',
                    'label' => __( 'Top bar icon bg hover color', 'carzine' ),
                    'desc' => __( 'Choose top bar icon hover color', 'carzine' ),
                    'type' => 'color',
                    'default' => '',
                    'sanitize_callback'=>'sanitize_hex_color'
            ),array(
                    'name' => 'top_bar_icon_bg',
                    'label' => __( 'Top Bar icon hover color. ', 'carzine' ),
                    'desc' => __( 'Choose top bar icon hover color', 'carzine' ),
                    'type' => 'color',
                    'default' => '',
                    'sanitize_callback'=>'sanitize_hex_color'
            ),
            array(
                    'name' => 'header_image_link',
                    'label' => __( 'Header Image Link', 'carzine' ),
                    'desc' => __( '<p>If you have set a header image you can have a link attached to it.</p>','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
                ),
            array(
                    'name' => 'copyright_text',
                    'label' => __( 'Change Copyright Text', 'carzine' ),
                    'desc' => __( '<p>
                    Replace the default copyright message at the bottom of the theme.</p>', 'carzine' ),
                    'type' => 'text',
                    'sanitize_callback'=>'wp_kses_post'
                ),
            ),
            OPTIONS_PREFIX.'socials' => array(
            array(
                    'name' => 'facebook',
                    'label' => __( 'Facebook URL', 'carzine' ),
                    'desc' => __( 'Your Facebook URL.','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            ),
            array(
                    'name' => 'twitter',
                    'label' => __( 'Twitter URL', 'carzine' ),
                    'desc' => __( 'Your Twitter URL.','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            ),
            array(
                    'name' => 'google_plus',
                    'label' => __( 'Google Plus URL', 'carzine' ),
                    'desc' => __( 'Your Google Plus URL.','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            ),
            array(
                    'name' => 'rss',
                    'label' => __( 'RSS URL', 'carzine' ),
                    'desc' => __( 'Your Feed/RSS URL.','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            ),
            array(
                    'name' => 'instagram',
                    'label' => __( 'Instagram URL', 'carzine' ),
                    'desc' => __( 'Your Instagram Page URL.','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            ),
            array(
                    'name' => 'pinterest',
                    'label' => __( 'Pinterest URL', 'carzine' ),
                    'desc' => __( 'Your Pinterest URL.','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            ),
            array(
                    'name' => 'linkedin',
                    'label' => __( 'Linkedin URL', 'carzine' ),
                    'desc' => __( 'Your Linkedin URL.','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            ),
            array(
                    'name' => 'dribbble',
                    'label' => __( 'Dribbble URL', 'carzine' ),
                    'desc' => __( 'Your Dribbble URL.','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            ),
            array(
                    'name' => 'youtube',
                    'label' => __( 'Youtube Channel URL', 'carzine' ),
                    'desc' => __( 'Your Youtube Channel URL.','carzine' ),
                    'type' => 'text',
                    'default' => '',
                    'sanitize_callback'=>'esc_url_raw'
            )
        ),
            OPTIONS_PREFIX.'featured_post_settings' => array(
             array(
                    'name' => 'disable_featured',
                    'label' => __( 'Disable Featured Posts', 'carzine' ),
                    'desc' => __( 'If you want to disable featuted posts, then tick "Yes".<br/>This setting overrides the "featured  post category" setting below.', 'carzine' ),
                    'type' => 'radio',
                    'default'=>'yes',
                    'options' => array(
                        'yes' => 'Yes',
                        'no' => 'No'
                    
             )),
            array(
                    'name' => 'featured_category',
                    'label' => __( 'Featured Post Category', 'carzine' ),
                    'desc' => __( 'Select the category of the fearured posts', 'carzine' ),
                    'type' => 'select',
                    'options' => $categories
            ),
             array(
                    'name' => 'featured_posts_number',
                    'label' => __( 'Featured Posts Number', 'carzine' ),
                    'desc' => __( 'Select the number of the featured posts.', 'carzine' ),
                    'type' => 'select',
                    'default'=>'2',
                    'options' => array(
                    '1'=>'1',
                    '2'=>'2',
                    '3'=>'3',
                    '4'=>'4',
                    '5'=>'5',
                    '6'=>'6',
                    '7'=>'7',
                    '8'=>'8',
                    '9'=>'9',
                    '10'=>'10'
             )
            )
        ),
            OPTIONS_PREFIX.'footer_columns'=>array(
            array(
                    'name' => 'footer_column_one_header',
                    'label' => __( 'Title for the first footer column', 'carzine' ),
                    'desc' => __( 'Title of the first footer column.', 'carzine' ),
                    'type' => 'text',
                    'sanitize_callback'=>'sanitize_text_field'
            ),
            array(
                    'name' => 'footer_column_one',
                    'label' => __( 'First from the left Footer Column', 'carzine' ),
                    'desc' => __( 'Fill this column with your text/HTML', 'carzine' ),
                    'type' => 'textarea',
                    'sanitize_callback'=>'wp_kses_post'
                    
            ),
            array(
                    'name' => 'footer_column_two_header',
                    'label' => __( 'Title for the second  footer column', 'carzine' ),
                    'desc' => __( 'Title of the second -from the left- footer column.', 'carzine' ),
                    'type' => 'text',
                    'sanitize_callback'=>'sanitize_text_field'
            ),
            array(
                    'name' => 'footer_column_two',
                    'label' => __( 'Second from the left Footer Column', 'carzine' ),
                    'desc' => __( 'Fill this column with your text/HTML', 'carzine' ),
                    'type' => 'textarea',
                    'sanitize_callback'=>'wp_kses_post'
            ),
            array(
                    'name' => 'footer_column_three_header',
                    'label' => __( 'Title for the third footer column', 'carzine' ),
                    'desc' => __( 'Title of the third-from the left- footer column.', 'carzine' ),
                    'type' => 'text',
                    'sanitize_callback'=>'sanitize_text_field'
            ),
            array(
                    'name' => 'footer_column_three',
                    'label' => __( 'Second from the right Footer Column', 'carzine' ),
                    'desc' => __( 'Fill this column with your text/HTML', 'carzine' ),
                    'type' => 'textarea',
                    'sanitize_callback'=>'wp_kses_post'
            ),
            array(
                    'name' => 'footer_column_four_header',
                    'label' => __( 'Title for the fourth footer column', 'carzine' ),
                    'desc' => __( 'Title of the fourth-from the left- footer column.', 'carzine' ),
                    'type' => 'text',
                    'sanitize_callback'=>'sanitize_text_field'
            ),
            array(
                    'name' => 'footer_column_four',
                    'label' => __( 'First from the right Footer Column', 'carzine' ),
                    'desc' => __( 'Fill this column with your text/HTML', 'carzine' ),
                    'type' => 'textarea',
                    'sanitize_callback'=>'wp_kses_post'
            )

            
        )
    );

        return $settings_fields;
    }

    function plugin_page() {
        echo '<div class="wrap">';

        $this->settings_api->show_navigation();
        $this->settings_api->show_forms();

        echo '</div>';
    }

    /**
     * Get all the pages
     *
     * @return array page names with key value pairs
     */
    function get_pages() {
        $pages = get_pages();
        $pages_options = array();
        if ( $pages ) {
            foreach ($pages as $page) {
                $pages_options[$page->ID] = $page->post_title;
            }
        }

        return $pages_options;
    }

}
endif;
$settings = new carzine_Settings();
function carzine_option( $option, $section, $default = '' ) {
 
    $options = get_option( $section );
 
    if ( isset( $options[$option] ) ) {
        return $options[$option];
    }
 
    return $default;
}

/***
* BREADCRUMBS WITHOUT A PLUGIN
*/
function carzine_the_breadcrumb() {
    global $post;
    echo '<ul id="breadcrumbs">';
    if (!is_home()) {
        echo '<li><a href="';
        echo home_url();
        echo '">';
        echo __('Home','carzine');
        echo '</a></li><li class="separator"> / </li>';
        if (is_category() || is_single()) {
            echo '<li>';
            single_cat_title('');
            if (is_single()) {
                echo '</li><li>';
                the_title();
                echo '</li>';
            }
        } elseif (is_page()) {
            if($post->post_parent){
                $anc = get_post_ancestors( $post->ID );
                $title = get_the_title();
                foreach ( $anc as $ancestor ) {
                    $output = '<li><a href="'.get_permalink($ancestor).'" title="'.get_the_title($ancestor).'">'.get_the_title($ancestor).'</a></li> <li class="separator">/</li>';
                }
                echo $output;
                echo '<strong title="'.$title.'"> '.$title.'</strong>';
            } else {
                echo '<li><strong> '.get_the_title().'</strong></li>';
            }
        }
    }
    if (is_tag()) { echo '</li><li>';
                single_tag_title();
                echo '</li>';}
    elseif (is_day()) {echo"<li>".__('Archive for ','carzine'); echo get_the_date('D F Y'); echo'</li>';}
    elseif (is_month()) {echo"<li>".__('Archive for ','carzine'); echo get_the_date('F Y'); echo'</li>';}
    elseif (is_year()) {echo "<li>".__('Archive for ','carzine'); echo get_the_date(' Y '); echo'</li>';}
    elseif (is_author()) {echo"<li>".__('Archive for  Author','carzine'); echo'</li>';}
    elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {echo "<li>Blog Archives"; echo'</li>';}
    elseif (is_search()) {echo"<li>".__('Search Results','carzine'); echo'</li>';}
    echo '</ul>';
}
/*************************
* RECENT VIDEOS WIDGET
*************************/
/**
 * Recent_Posts widget class
 *
 * @since 2.8.0
 */
class Carzine_Widget_Recent_Videos extends WP_Widget {

    function __construct() {
        $widget_ops = array('classname' => 'widget_recent_videos', 'description' => __( "Your site&#8217;s most recent video posts.",'carzine') );
        parent::__construct('carzine-recent-videos', __('Carzine Recent Videos','carzine'), $widget_ops);
        $this->alt_option_name = 'carzine_widget_recent_videos';

        add_action( 'save_post', array($this, 'flush_widget_cache') );
        add_action( 'deleted_post', array($this, 'flush_widget_cache') );
        add_action( 'switch_theme', array($this, 'flush_widget_cache') );
    }

    function widget($args, $instance) {
        $cache = array();
        if ( ! $this->is_preview() ) {
            $cache = wp_cache_get( 'carzine_widget_recent_videos', 'widget' );
        }

        if ( ! is_array( $cache ) ) {
            $cache = array();
        }

        if ( ! isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }

        if ( isset( $cache[ $args['widget_id'] ] ) ) {
            echo $cache[ $args['widget_id'] ];
            return;
        }

        ob_start();
        extract($args);

        $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Videos','carzine' );

        /** This filter is documented in wp-includes/default-widgets.php */
        $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

        $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
        if ( ! $number )
            $number = 5;
        $show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;

        /**
         * Filter the arguments for the Recent Posts widget.
         *
         * @since 3.4.0
         *
         * @see WP_Query::get_posts()
         *
         * @param array $args An array of arguments used to retrieve the recent posts.
         */
        $r = new WP_Query( apply_filters( 'widget_posts_args', array(
            'posts_per_page'      => $number,
            'tax_query'          =>array(array(
                 'taxonomy' => 'post_format',
                 'field' => 'slug',
                 'terms' => 'post-format-video'
            )),
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true
        ) ) );

        if ($r->have_posts()) :
?>
        <?php echo $before_widget; ?>
        <?php if ( $title ) echo $before_title . $title . $after_title; ?>
        <ul>
        <?php while ( $r->have_posts() ) : $r->the_post(); ?>
            <li>
            
                <a href="<?php the_permalink(); ?>">
                <?php if(has_post_thumbnail()):the_post_thumbnail('',array('class'=>'video_widget img-responsive')); endif; ?> 
                </a>
               
            <?php if ( $show_date ) : ?>
                <span class="post-date"><?php echo get_the_date(); ?></span>
            <?php endif; ?>
            </li>
        <?php endwhile; ?>
        </ul>
        <?php echo $after_widget; ?>
<?php
        // Reset the global $the_post as this query will have stomped on it
        wp_reset_postdata();

        endif;

        if ( ! $this->is_preview() ) {
            $cache[ $args['widget_id'] ] = ob_get_flush();
            wp_cache_set( 'carzine_widget_recent_videos', $cache, 'widget' );
        } else {
            ob_end_flush();
        }
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['show_date'] = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
        $this->flush_widget_cache();

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset($alloptions['carzine_widget_recent_videos']) )
            delete_option('carzine_widget_recent_videos');

        return $instance;
    }

    function flush_widget_cache() {
        wp_cache_delete('carzine_widget_recent_videos', 'widget');
    }

    function form( $instance ) {
        $title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
        $show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
?>
        <p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:','carzine' ); ?></label>
        <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

        <p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:','carzine' ); ?></label>
        <input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>

        <p><input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />
        <label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php _e( 'Display post date?','carzine' ); ?></label></p>
<?php
    }
}
function carzine_register_custom_widgets() {
    register_widget( 'Carzine_Widget_Recent_Videos' );
}
add_action( 'widgets_init', 'carzine_register_custom_widgets' );
?>